#include <iostream>
#include <set>
#include <map>
#include <math.h>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;
typedef long long ll;
const int VERYLONGINT = 1000000001;

struct tf {
    vector<int> tree;
    int size;
    tf(int n) {
        size = n + 1;
        tree.assign(n + 1, 0);
    }
    void add(int p, int v) {
        for (int i = p + 1; i < size; i += (i & (-i)))
            tree[i] += v;
    }

};
vector<bool> bul;
vector<vector<int>> g;
void dfs(int now) {
    bul[now] = true;
    for (int i = 0; i < g[now].size(); i++) {
        if (bul[g[now][i]])
            continue;
        dfs(g[now][i]);
    }
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n;
    int m;
    cin >> m;
    g.assign(n, vector<int>(0));
    bul.assign(n, false);
    vector<vector<int>> obg(n);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        g[--a].push_back(--b);
        obg[b].push_back(a);
    }
    if (m < n) {
        cout << "NO\n";
        return 0;
    }
    int r = m - n;
    bool ok = true;
    dfs(0);
    for (int i = 0; i < n; i++)
        if (!bul[i] || obg[i].size() == 0 || g[i].size() == 0)
            ok = false;
    if (!ok) {
        cout << "NO\n";
        return 0;
    }
    bul.assign(n, false);
    vector<int> res(n);
    vector<pair<int, int>> q(n);
    for (int i = 0; i < n; i++)
        q[i] = { g[i].size(), i };
    sort(q.begin(), q.end());
    for (int i = 0; i < n; i++) {
        int j = 0;
        while (j < g[q[i].second].size() && bul[g[q[i].second][j]] == true)
            j++;
        if (j == g[q[i].second].size()) {
            cout << "NO\n";
            return 0;
        }
        bul[g[q[i].second][j]] = true;
        res[q[i].second] = g[q[i].second][j];
    }
    cout << "YES\n1";
    int i = res[0];
    while (i != 0) {
        cout << " " << i + 1;
        i = res[i];
    }
    cout << " 1";
    return 0;
}